/**
 *  Task of rank 0 receives hello from other tasks
 */
#include <stdio.h>
#include <string.h>
#include <mpi.h>

int main( int argc, char **argv )
{
	int        myRank, nbProcs;
	int		   cpuId=-1, nameLength;
	char       message[100], procName[MPI_MAX_PROCESSOR_NAME];
	int 	   src;      // rank of source process 
	int        tag=50;   // tag of message
	MPI_Status status;
	
	MPI_Init( &argc, &argv );
	MPI_Comm_rank( MPI_COMM_WORLD, &myRank );
	MPI_Comm_size( MPI_COMM_WORLD, &nbProcs );

	MPI_Get_processor_name( procName, &nameLength);
	cpuId = sched_getcpu();

	if ( myRank != 0 ) { // rank!=0 sends its message to rank 0
    	sprintf( message, "Hello from %d on node %s-cpu%d!",
            	myRank, procName, cpuId );
    	MPI_Send( message, strlen(message)+1, MPI_CHAR, 
	        	0, tag, MPI_COMM_WORLD );
	}
	else // rank 0 receives the messages from others
      for ( src=1; src<nbProcs; src++ ) { // nbProcs-1 processes
          MPI_Recv( message, 100, MPI_CHAR, src,
                   tag, MPI_COMM_WORLD, &status );
          printf( "%s\n", message );
      }
		
	MPI_Finalize();
	return 0;
}
