/**
 * Example for testing SEND and RECV functions
 * Modify tag, src/dest to create deadlock
 * Modify the type and value of send and recv buffer
 * for other communications 
 * 
 * to execute with 2 processes (tasks)
 */

#include <stdio.h>
#include <mpi.h>

int main( int argc, char **argv )
{
    int  myRank=-1, nbProcs=0;
 	char procName[MPI_MAX_PROCESSOR_NAME];
 	int  nameLength, cpuId=-1;

    int        tag=20;
    MPI_Status status;

    int  sendBuf[2]={0}, recvBuf[2]={0}; // send and receive buffer

    MPI_Init( &argc, &argv );
    MPI_Comm_rank( MPI_COMM_WORLD, &myRank);
    MPI_Comm_size( MPI_COMM_WORLD, &nbProcs);
    
    MPI_Get_processor_name( procName, &nameLength);
    cpuId = sched_getcpu();

    /* Modify the content of sendBuf */
    sendBuf[0] = nbProcs+myRank;
    sendBuf[1] = 1 << myRank;

    /* rank 0 sends/receives to/from rank 1 */
    /* rank 1 sends/receives to/from rank 1 */
    /* same tag for send and receive operation */
    MPI_Send( sendBuf, 2, MPI_INT, (1+myRank)%2, tag, MPI_COMM_WORLD );
    MPI_Recv( recvBuf, 2, MPI_INT, (1+myRank)%2, tag, MPI_COMM_WORLD, &status );
 
    /* different tag for send and receive */
 //   MPI_Send( sendBuf, 2, MPI_INT, (1+myRank)%2, tag+(1+myRank)%2, MPI_COMM_WORLD );
 //   MPI_Recv( recvBuf, 2, MPI_INT, (1+myRank)%2, tag+(myRank)%2, MPI_COMM_WORLD, &status );
    
    printf( "Rank %d: sendBuf={%d, %d}, recvBuf={%d, %d}\n",
           myRank, sendBuf[0], sendBuf[1], recvBuf[0], recvBuf[1] );

    MPI_Finalize();
    return 0;
}
