/**
 * Parallel computing of pi in using rectangle rule - Send/Recv version
 * The total rectangles number is 
 *   - read from keyboard when the program is executed on command line
 *   - read from a text file "rectsNb.txt" when SLURM is used
 * 
 * The task of rank 0 
 *   - reads the total rectangles number
 *   - computes the rectangles number for each task
 *   - sends this value to others
 *   - computes ...
 *   - receives the partial results from other tasks
 *   - computes an approximation of pi
 * 
 * Compiling: mpicc pi_rectangle_SendRecv.c -o pi_rectangle -lm
 */

#include <stdio.h>
#include <math.h>
#include <mpi.h>

int  main(int argc, char **argv)
{
    double PI25DGT = 3.141592653589793238462643;
    int    nb_rectangles= 200, rects_per_proc=0, i;
    double x, h, my_sum=0.0, pi=0.0;

    int    my_deb=0, my_end=0;
    int    myRank, nbProcs, tag=50;

    MPI_Status status;

    MPI_Init( &argc, &argv );
    MPI_Comm_rank( MPI_COMM_WORLD, &myRank );
    MPI_Comm_size( MPI_COMM_WORLD, &nbProcs);

    if (myRank==0) {  // process of rank 0 does inputs 
        printf("Please input the number of rectangles for [0, 1]: ");
        fflush(stdout);
        scanf("%d%*c", &nb_rectangles);

        rects_per_proc = nb_rectangles / nbProcs;

        // process of rank 0 sends "rects_per_proc" to all other processes
        /**
         * add here instructions allowing rank 0 to send "rects_per_proc" to rank≠0
         */
        
     }
    else { // process of rank≠0 receives rects_per_proc from rank 0
        /**
         * add here instruction allowing rank≠0 to receive "rects_per_proc" from rank 0
         */
    }
    
 //   printf("Proc %d : rects_per_proc=%d\n", myrank, rects_per_proc);

    h = 1.0 / (rects_per_proc*nbProcs);
 
    my_deb=myRank*rects_per_proc;   // compute the interval of each process
    my_end=my_deb+rects_per_proc;
 
    for (i=my_deb; i<my_end; i++) { // each process compute the local sum
        x = (i+0.5)*h;         
        my_sum += 4.0 / (1.0 + x*x);
    }

    if (myRank != 0) {
         /**
         * add here instruction allowing rank≠0 to send "my_sum" to rank 0
         */
    }
    else {  // rank 0 receive my_sum of other processes and sum them
        /**
         * add here instructions allowing rank 0 to receive "my_sum" from rank≠0
         * and them to its "my_sum", so that the result my be used to compute pi
         */
  
        pi = my_sum * h;   // compute pi

        printf("pi is approximatly: %0.16f\n", pi);
        printf("Error to PI25DGT is %.16f\n", fabs(pi-PI25DGT));
    }

    MPI_Finalize();
    return 0;
}

