#include <math.h>
#include <stdio.h>
#include <stdlib.h>
// #include "omp.h"

 
int main(int argc, char **argv) 
{

  int IterMax=10000, n=500;
  double res, resi, err,bb, tol = 1.e-6;
  int i,j,iter, nbprocs = 1;
  double *A, *b, *x, *xnew;
  
  /* inputs parameters : exe n nbprocs */
  n = atoi(argv[1]);  
  nbprocs = atoi(argv[2]); 
 
  
  printf ( "\n" );
  printf ( "  Number of variables  N = %d\n", n );
  printf ( "  Max number of iterations M = %d\n", IterMax );
  
   /* Arrays allocations */ 
  A = malloc(n * n * sizeof(double));
  b = malloc(n * sizeof(double));
  x = malloc(n * sizeof(double));
  xnew = malloc(n * sizeof(double));

   /*  Set up (Hilbert) matrix and right hand side. */
    for ( i = 0; i < n; i++ ){
       for (j=0; j<n; j++){
        A[n*i+j]=1.0/(double)(i+j+1);
       }
    }
 
    bb = 0.0;
    for (i=0; i<n; i++){
       b[i] = 0.0;
       for (j=0; j<n; j++){
          b[i] = b[i] + A[n*i+j];
      }
      bb += b[i]*b[i];
      A[n*i+i] += b[i]+1.0;
   }
    
/* Initialize the solution estimate to 0. */
 
    for ( i = 0; i < n; i++ ){
      x[i] = 0.0;
    }

/* Iterate */
  res = 1.0;
  while ( iter < IterMax && res > 1.e-6)
  {
     iter++;
     /*Jacobi update.*/
 
      for ( i = 0; i < n; i++ ){
        xnew[i] = b[i]+A[n*i+i]*x[i];
        for (j = 0; j < n; j++){
           xnew[i] = xnew[i]-A[n*i+j]*x[j];
        }
        xnew[i] = xnew[i]/A[n*i+i];
      }

      /* stopping criterion */
      res = 0.0;
      for ( i = 0; i < n; i++ ){
         resi = b[i];
         for (j=0; j<n; j++){
            resi = resi - A[n*i+j]*xnew[j];
         }
         res=res+resi*resi;
      }
      err=sqrt(res)/sqrt(bb);
      /* update the solution */
      for ( i = 0; i < n; i++ ){
        x[i] = xnew[i];
      }
  
      printf ("Iter =  %8d  residual = %14.6f  rela-error = %14.6f\n", iter, res, err );
 
   }
 
/* Terminate. */
  printf ( "\n" );
  printf ( "  Normal end of execution.\n" );

  return 0;
}

