#include <stdio.h>
#include <string.h>
#include <sched.h>

#include <mpi.h>

#define MSG_LENGTH 512

int main( int argc, char **argv )
{
	int			rang, nbProcs;
	int			dest=0, source;
	int			etiquette=50;
	MPI_Status  statut;
	char		message[MSG_LENGTH];
	
	int			nameLength;
	char		proc_name[MPI_MAX_PROCESSOR_NAME];
	
	MPI_Init( &argc, &argv );

	MPI_Comm_rank( MPI_COMM_WORLD, &rang );
	MPI_Comm_size( MPI_COMM_WORLD, &nbProcs );

	MPI_Get_processor_name( proc_name, &nameLength);

	if ( rang != 0 ) {
		sprintf( message, "Bonjour de la part de %d on Processor %s.\n", rang, proc_name );
		MPI_Send( message, strlen(message)+1, MPI_CHAR, dest, 
				 etiquette, MPI_COMM_WORLD );
	}
	else 
		for ( source=1; source<nbProcs; source++ ) {
			MPI_Recv( message, MSG_LENGTH, MPI_CHAR, source, etiquette, MPI_COMM_WORLD, &statut );
			printf( "%s", message );
		}
	
	MPI_Finalize();
	return 0;
}
