#include <stdio.h>
#include <string.h>
#include <sched.h>

#include <mpi.h>

#define MSG_LENGTH 512

int main( int argc, char **argv )
{
	int			myRank, nbProcs, cpuId=-1;
	int			tag=50;
	MPI_Status  statut;
	char		message[MSG_LENGTH];
	
	int			nameLength;
	char		procName[MPI_MAX_PROCESSOR_NAME];
	
	MPI_Init( &argc, &argv );

	MPI_Comm_rank( MPI_COMM_WORLD, &myRank );
	MPI_Comm_size( MPI_COMM_WORLD, &nbProcs );

	MPI_Get_processor_name( procName, &nameLength);
	cpuId = sched_getcpu();

	if ( myRank == 1 ) {
		sprintf( message, "Bonjour de la part de %d on Processor %s-cpu%d!\n", myRank, procName, cpuId );
		MPI_Send( message, strlen(message)+1, MPI_CHAR, 0, 
				 tag, MPI_COMM_WORLD );
	}
	else if (myRank == 0) { 
		MPI_Recv( message, MSG_LENGTH, MPI_CHAR, 1, tag, MPI_COMM_WORLD, &statut );
		printf( "Proc %d: %s", myRank, message );
	}
	
	MPI_Finalize();
	return 0;
}
