#include <stdio.h>
#include <mpi.h>

//#define _GNU_SOURCE
#include <sched.h>

int main( int argc, char **argv )
{
    int  myRank=-1;   // rank of current process
    int  nbProcs=0;   // processes number (total)
    int  cpuId=-1;    // number of core used
    char procName[MPI_MAX_PROCESSOR_NAME]; // name of node used
    int  nameLength=0; // length of procName
  
    /* enrollement in MPI context */
    MPI_Init( &argc, &argv );

    /* get the rank of process and the processes number */
    MPI_Comm_rank( MPI_COMM_WORLD, &myRank);
    MPI_Comm_size( MPI_COMM_WORLD, &nbProcs);
    
    /* get the node's name on which the process is running */
    MPI_Get_processor_name( procName, &nameLength);
    cpuId = sched_getcpu();

    printf( "Hello from process %d/%d on CPU %d of node %s\n",
           myRank, nbProcs, cpuId, procName );

    /* exit the MPI context */
    MPI_Finalize();
    return 0;
}
