/**
 * Multiplication de deux matrices carrées
 * Compilation : gcc -fopenmp prodMatriciel_parallelfor.c -o exe
 * Visulation des processus : ps -L affiche les infos concernant les light weight process
 *
 * Trois manières de fixer le nombre de threads
 *  - avec la clause "num_threads (n)" de "omp parallel"
 *  - avec la fonction omp_set_num_threads(n)
 *  - avec la variable d'environnement OMP_NUM_THREADS, ex. : export OMP_NUM_THREADS=16
 */

#include <stdio.h>
#include <stdlib.h>

#include <omp.h>

#define SIZE 1000      /* taille de matrice carree     */


int main(int argc, char **argv)
{
	double **A, **B, **C;

	int chunk=10;
	double time_start, time_end;

	int i, j, k;

	A = (double**) malloc(sizeof(double*)*SIZE);
	B = (double**) malloc(sizeof(double*)*SIZE);
	C = (double**) malloc(sizeof(double*)*SIZE);

	for (i = 0; i < SIZE; ++i)
	{
		A[i] = (double*) malloc(sizeof(double)*SIZE);
		B[i] = (double*) malloc(sizeof(double)*SIZE);
		C[i] = (double*) malloc(sizeof(double)*SIZE);
	}


	time_start = omp_get_wtime();

    /* Initialisation de deux matrices : A et B */
    /* On peut ajouter la clause num_threads(nbthreads) en fin de */
    /* la ligne suivante pour fixer le nombre de threads utilises */
	#pragma omp parallel for shared(A, B) private(i,j) schedule(static, chunk) num_threads(8)
	for (i=0; i<SIZE; i++) 
		for (j=0; j<SIZE; j++) {
			A[i][j] = i*SIZE+j; 
			B[i][j] = i+j; 
		}

    /* Multiplication de matrice C=A*B */
    /* tid = omp_get_thread_num(); pour avoir le tid du thread */
	//printf("Thread %d commence la multiplication de matrices\n", tid);
	#pragma omp parallel for shared(A, B, C) private(i,j,k) schedule(static, chunk) num_threads(8)
	for (i=0; i<SIZE; i++) 
		for (j=0; j<SIZE; j++) {
			C[i][j] = 0;
			for (k=0; k<SIZE; k++)
				C[i][j] += A[i][k] * B[k][j];
		}
	
	time_end = omp_get_wtime();
	printf("Temps utilise par le calcul %f\n", time_end-time_start);

	return 0;
} 
