#include <mpi.h>
#include <stdio.h>
#include <string.h>
#include <utmpx.h>

//#include <sched.h>

//a mettre dans .bashrc : 
//if ! (which mpicc>/dev/null 2>&1) && [ -d /usr/lib64/openmpi ]
//then
//	export PATH=/usr/lib64/openmpi/bin:$PATH
//	export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/usr/lib64/openmpi/lib
//fi

// compilation  : mpicc hello.c -o hello
// execution (sur un seul noeud) : mpiexec –n 8 ./hello 



int main(int argc, char **argv)
{
	int myrank, nbprocs, nameLength;
    char proc_name[MPI_MAX_PROCESSOR_NAME];
	unsigned cpu, numanode;
	
	
	MPI_Init( &argc, &argv );
	MPI_Comm_rank( MPI_COMM_WORLD, &myrank );
	MPI_Comm_size( MPI_COMM_WORLD, &nbprocs);

		
	MPI_Get_processor_name( proc_name, &nameLength);

	printf("Bonjour de la part de thread %d sur %s, cpu %d.\n", myrank, proc_name, sched_getcpu() );
	


	MPI_Finalize();
	return 0;
}
